<?php
/**
 * API endpoint để tăng lượt xem cho tin tức
 */

// Load cấu hình chung
require_once __DIR__ . '/config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    returnJson(['success' => false, 'message' => 'Only POST method allowed'], 405);
    exit();
}

try {
    // Lấy dữ liệu từ request
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!$input || !isset($input['id'])) {
        returnJson(['success' => false, 'message' => 'ID tin tức là bắt buộc'], 400);
        exit();
    }
    
    $newsId = (int)$input['id'];
    
    if ($newsId <= 0) {
        returnJson(['success' => false, 'message' => 'ID tin tức không hợp lệ'], 400);
        exit();
    }
    
    // Kiểm tra tin tức có tồn tại không
    $stmt = $pdo->prepare("SELECT id, title, views FROM news WHERE id = ? AND status = 'published'");
    $stmt->execute([$newsId]);
    $news = $stmt->fetch();
    
    if (!$news) {
        returnJson(['success' => false, 'message' => 'Không tìm thấy tin tức hoặc tin tức chưa được xuất bản'], 404);
        exit();
    }
    
    // Kiểm tra để tránh spam views (có thể kiểm tra IP, session, etc.)
    $clientIp = $_SERVER['HTTP_X_FORWARDED_FOR'] ?? $_SERVER['REMOTE_ADDR'] ?? 'unknown';
    $userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'unknown';
    
    // Simple rate limiting - chỉ cho phép 1 view per IP per news per 5 minutes
    $cacheKey = "news_view_" . $newsId . "_" . md5($clientIp . $userAgent);
    $cacheFile = sys_get_temp_dir() . '/' . $cacheKey . '.tmp';
    
    if (file_exists($cacheFile) && (time() - filemtime($cacheFile)) < 300) {
        // Đã xem trong vòng 5 phút, không tăng view nữa
        returnJson([
            'success' => true,
            'message' => 'Lượt xem đã được ghi nhận trước đó',
            'views' => (int)$news['views'],
            'incremented' => false
        ]);
        exit();
    }
    
    // Tăng lượt xem
    $stmt = $pdo->prepare("UPDATE news SET views = views + 1 WHERE id = ?");
    $result = $stmt->execute([$newsId]);
    
    if ($result) {
        // Lưu cache để tránh spam
        file_put_contents($cacheFile, time());
        
        // Lấy số views mới
        $stmt = $pdo->prepare("SELECT views FROM news WHERE id = ?");
        $stmt->execute([$newsId]);
        $updatedNews = $stmt->fetch();
        
        returnJson([
            'success' => true,
            'message' => 'Tăng lượt xem thành công',
            'views' => (int)$updatedNews['views'],
            'incremented' => true,
            'news_title' => $news['title']
        ]);
    } else {
        returnJson(['success' => false, 'message' => 'Không thể cập nhật lượt xem'], 500);
    }
    
} catch (PDOException $e) {
    returnJson([
        'success' => false,
        'message' => 'Lỗi cơ sở dữ liệu: ' . $e->getMessage()
    ], 500);
} catch (Exception $e) {
    returnJson([
        'success' => false,
        'message' => 'Lỗi hệ thống: ' . $e->getMessage()
    ], 500);
}
?>
