
-- Ví dụ: USE `cpses_mu7972ew0n_news`; hoặc tên database mà hosting cung cấp

-- Nếu bạn đang dùng localhost XAMPP:
-- USE `mubathu_news`;

-- Nếu bạn đang dùng hosting, hãy thay đổi tên database:
-- USE `tên_database_của_hosting`;


-- Tạo bảng news
CREATE TABLE IF NOT EXISTS `news` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(500) NOT NULL COMMENT 'Tiêu đề tin tức',
  `content` longtext NOT NULL COMMENT 'Nội dung tin tức',
  `image_url` varchar(1000) DEFAULT NULL COMMENT 'URL hình ảnh',
  `author` varchar(100) DEFAULT 'Admin' COMMENT 'Tác giả',
  `status` enum('published','draft','archived') DEFAULT 'published' COMMENT 'Trạng thái tin tức',
  `category` enum('announcement','event','update','guide','maintenance') DEFAULT 'announcement' COMMENT 'Loại tin tức',
  `priority` int(11) DEFAULT 5 COMMENT 'Mức độ ưu tiên (1-10, càng cao càng ưu tiên)',
  `views` int(11) DEFAULT 0 COMMENT 'Số lượt xem',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Ngày tạo',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Ngày cập nhật',
  PRIMARY KEY (`id`),
  KEY `idx_status` (`status`),
  KEY `idx_category` (`category`),
  KEY `idx_created_at` (`created_at`),
  KEY `idx_priority` (`priority`),
  KEY `idx_views` (`views`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Thêm dữ liệu mẫu
INSERT INTO `news` (`title`, `content`, `image_url`, `author`, `status`, `views`, `priority`, `category`) VALUES
('Chào mừng đến với Mu Bà Thú Online', 
 'Chúng tôi hân hạnh giới thiệu phiên bản mới nhất của game Mu Bà Thú Online với nhiều tính năng hấp dẫn và cải tiến vượt trội. Trải nghiệm thế giới phép thuật đầy màu sắc với đồ họa 3D sống động và gameplay mượt mà.', 
 '/images/news-1.jpg', 
 'GameMaster', 
 'published',
 1250,
 1,
 'announcement'),

('Sự kiện đặc biệt - Săn Boss siêu cấp', 
 'Tham gia sự kiện săn Boss siêu cấp để nhận được những phần thưởng giá trị. Sự kiện diễn ra từ ngày 15/8 đến 30/8. Đừng bỏ lỡ cơ hội nhận được trang bị hiếm và vật phẩm quý giá.', 
 '/images/boss-event.jpg', 
 'EventManager', 
 'published',
 2840,
 2,
 'event'),

('Cập nhật phiên bản 2.5 - Tính năng mới', 
 'Phiên bản 2.5 mang đến nhiều tính năng mới: Hệ thống Guild War nâng cao, Map mới với Boss độc quyền, Weapon và Armor mới với thuộc tính đặc biệt. Hãy trải nghiệm ngay hôm nay!', 
 '/images/update-2-5.jpg', 
 'Developer', 
 'published',
 3456,
 3,
 'update'),

('Hướng dẫn newbie - Bắt đầu cuộc phiêu lưu', 
 'Dành cho những người chơi mới: Hướng dẫn chi tiết từ việc tạo nhân vật, nâng cấp kỹ năng, săn đồ cho đến PvP. Tất cả những gì bạn cần biết để trở thành một chiến binh mạnh mẽ.', 
 '/images/newbie-guide.jpg', 
 'Guide Master', 
 'published',
 1876,
 4,
 'guide'),

('Thông báo bảo trì server định kỳ', 
 'Server sẽ được bảo trì định kỳ vào lúc 02:00 - 06:00 sáng thứ 2 hàng tuần để đảm bảo chất lượng game tốt nhất. Trong thời gian này, người chơi sẽ không thể truy cập game.', 
 '/images/maintenance.jpg', 
 'Admin', 
 'published',
 567,
 5,
 'maintenance');


